const { category } = require("../../models/blogs/categoryModel");
const {sequelize} = require("../../config/sequelize")
const { Op } = require("sequelize");

const CategoryControllers = {

 create: async (req, res) => {
  try {
    const { name } = req.body;

    if (!name) {
      return res.status(400).json({
        success: false,
        message: "Category Name field is missing!",
      });
    }

    const createdCategory = await category.create(req.body);

    if (createdCategory?.error) {
      return res.status(400).json({
        success: false,
        message: createdCategory.error,
      });
    }

    res.status(201).json({
      success: true,
      message: "Category created successfully!",
      data: {
        id: createdCategory.id,
        name: createdCategory.name,
        slug: createdCategory.slug,
      },
    });
  } catch (error) {
    console.error("Create Error:", error);
    res.status(500).json({
      success: false,
      message: error.message || "Internal Server Error",
    });
  }
},

  getAllCategory: async (req, res) => {
    try {
      const allCategories = await category.getcategory();
      if (allCategories) {
        res.status(200).json({
          success: true,
          message: "Category fetched successfully!",
          data: allCategories,
        });
      } else {
        res.status(404).json({
          success: false,
          message: "No Category found",
        });
      }
    } catch (error) {
      res.status(500).json({
        success: false,
        message: error.message,
      });
    }
  },

 updateCategory: async (req, res) => {
  const { id } = req.params;
  const updatedData = req.body;

  try {
    const updatedCategory = await category.updatecategory(id, updatedData);

    if (updatedCategory?.error) {
      return res.status(400).json({
        success: false,
        message: updatedCategory.error,
      });
    }

    if (!updatedCategory) {
      return res.status(404).json({
        success: false,
        message: "Category not found or no changes made",
      });
    }

    res.status(200).json({
      success: true,
      message: "Category updated successfully!",
      data: updatedCategory,
    });

  } catch (error) {
    res.status(500).json({
      success: false,
      message: error.message || "Internal Server Error",
    });
  }
},

  deleteCategory: async (req, res) => {
    const { id } = req.params;
    try {
      const isDeleted = await category.deletecategory(id);
      if (isDeleted) {
        res.status(200).json({
          success: true,
          ...isDeleted,
        });
      } else {
        res.status(404).json({
          success: false,
          message: "Category not found",
        });
      }
    } catch (error) {
      res.status(500).json({
        success: false,
        message: error.message,
      });
    }
  },

  getSingleCategory: async (req, res) => {
    const { id } = req.params;
    try {
      const singleCategory = await category.Get_Single_category(id);
      if (singleCategory) {
        res.status(200).json({
          success: true,
          message: "Category fetched successfully!",
          data: singleCategory,
        });
      } else {
        res.status(404).json({
          success: false,
          message: "Category not found",
        });
      }
    } catch (error) {
      res.status(500).json({
        success: false,
        message: error.message,
      });
    }
  }

};

module.exports = CategoryControllers;
