const { agencySectionModel , agencySection} = require("../../models/home/agencySectionModel");
const { metaData } = require("../../models/metaDataModel");
const SliderBannerController = require("../home/sliderBannerController");

const homepageController = {
getAllDataHomePage: async (req, res) => {
  try {
    const page_for = "home_page";
    const metainformation = await metaData.get_Single_page_by_slug(page_for);

    const sliderBanner = await SliderBannerController.getAll(); // ✅ use model/service, not controller
    const agencyData = await agencySection.getAll();

    if (!agencyData.length) {
      return res.status(404).json({ success: false, message: "No Content found." });
    }

    const response = {
      metaSectionJson: metainformation,
      sliderBannerJson: sliderBanner,
      agencySectionJson: agencyData,
    };

    res.status(200).json({ success: true, data: response });

  } catch (err) {
    res.status(500).json({ success: false, message: err.message });
  }
}


  
};

module.exports = homepageController;
