const { agencySectionModel , agencySection} = require("../../models/home/agencySectionModel");

const agencyControllers = {
 create: async (req, res) => {
  try {
    const { main_heading_1, main_heading_2, content_para_1, content_para_2 } = req.body;

    const data = {
      main_heading_1: main_heading_1?.trim(),
      main_heading_2: main_heading_2?.trim(),
      content_para_1: content_para_1?.trim(),
      content_para_2: content_para_2?.trim(),
    };

    const result = await agencySection.create(data);

    if (result?.error) {
      return res.status(400).json({ success: false, message: result.error });
    }

    res.status(201).json({
      success: true,
      message: "Services section created successfully!",
      data: result,
    });
  } catch (err) {
    res.status(500).json({ success: false, message: err.message });
  }
},

  getAll: async (req, res) => {
    try {
      const result = await agencySection.getAll();
      if (!result.length) {
        return res.status(404).json({ success: false, message: "No Content found." });
      }
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getSingle: async (req, res) => {
    try {
      const entry = await agencySection.getSingle(req.params.id);
      if (!entry) {
        return res.status(404).json({ success: false, message: "Content not found." });
      }
      res.status(200).json({ success: true, data: entry });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  update: async (req, res) => {
    try {
    const { main_heading_1, main_heading_2, content_para_1, content_para_2 } = req.body;

    const data = {
      main_heading_1: main_heading_1?.trim(),
      main_heading_2: main_heading_2?.trim(),
      content_para_1: content_para_1?.trim(),
      content_para_2: content_para_2?.trim(),
    };
      const updated = await agencySection.update(req.params.id, data);
      if (!updated) {
        return res.status(404).json({ success: false, message: "Content not found." });
      }

      res.status(200).json({ success: true, message: "Content updated!", data: updated });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  delete: async (req, res) => {
    try {
      const deleted = await agencySection.delete(req.params.id);
      if (!deleted) {
        return res.status(404).json({ success: false, message: "Content not found." });
      }
      res.status(200).json({ success: true, ...deleted });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },
};

module.exports = agencyControllers;
