const { logoslider } = require("../../models/home/logosliderModel");
const uploadDir = "uploads/logo_slider";

const LogosliderController = {
  create: async (req, res) => {
    try {
      const { img_alt, logo_for } = req.body;
      const data = { img_alt, logo_for };

      if (req.file) {
        data.image_path = `/${uploadDir}/${req.file.filename}`;
      }

      const result = await logoslider.create(data);
      if (result?.error) {
        return res.status(400).json({ success: false, message: result.error });
      }

      res.status(201).json({ success: true, message: "Logo uploaded!", data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getAll: async (req, res) => {
    try {
      const result = await logoslider.getAll();
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },


  filterlogoforwise: async (req, res) => {
    try {
      const result = await logoslider.filterlogoforwise(req.params.logo_for);
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },
  

  getSingle: async (req, res) => {
    try {
      const result = await logoslider.getSingle(req.params.id);
      if (!result) return res.status(404).json({ success: false, message: "Logo not found" });
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  update: async (req, res) => {
    try {
      const { img_alt, logo_for } = req.body;
      const data = { img_alt, logo_for };

      if (req.file) {
        data.image_path = `/${uploadDir}/${req.file.filename}`;
      }

      const result = await logoslider.update(req.params.id, data);
      if (!result) return res.status(404).json({ success: false, message: "Logo not found" });

      res.status(200).json({ success: true, message: "Logo updated!", data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  delete: async (req, res) => {
    try {
      const result = await logoslider.delete(req.params.id);
      if (!result) return res.status(404).json({ success: false, message: "Logo not found" });
      res.status(200).json({ success: true, ...result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },
};

module.exports = LogosliderController;
