const PortfolioSection = require("../../models/home/portfolioSectionModel");

const portfolioSectionController = {
 create: async (req, res) => {
  try {
    const { main_heading, cta_button_link, cta_button_text } = req.body;

    // ✅ Simple input validation
    if (!main_heading || !cta_button_link || !cta_button_text) {
      return res.status(400).json({
        success: false,
        message: "All fields (main_heading, cta_button_link, cta_button_text) are required.",
      });
    }

    // ✅ Map to model fields
    const data = {
      main_heading,
      cta_link: cta_button_link,
      cta_text: cta_button_text,
    };

    const created = await PortfolioSection.create(data);

    res.status(201).json({
      success: true,
      message: "Portfolio Section created successfully!",
      data: created,
    });
  } catch (err) {
    res.status(500).json({
      success: false,
      message: err.message,
    });
  }
} ,
  getAll: async (req, res) => {
    try {
      const data = await PortfolioSection.findAll();
      res.json({ success: true, data });
    } catch (err) {
      res.json({ success: false, message: err.message });
    }
  },

  getSingle: async (req, res) => {
    try {
      const data = await PortfolioSection.findByPk(req.params.id);
      if (!data) return res.json({ success: false, message: "Record not found" });

      res.json({ success: true, data });
    } catch (err) {
      res.json({ success: false, message: err.message });
    }
  },

  update: async (req, res) => {
    try {
      const { id } = req.params;
      const [updated] = await PortfolioSection.update(req.body, { where: { id } });

      if (!updated) return res.json({ success: false, message: "Update failed or record not found." });

      const updatedData = await PortfolioSection.findByPk(id);
      res.json({ success: true, message: "Updated successfully", data: updatedData });
    } catch (err) {
      res.json({ success: false, message: err.message });
    }
  },

  delete: async (req, res) => {
    try {
      const { id } = req.params;
      const deleted = await PortfolioSection.destroy({ where: { id } });

      if (!deleted) return res.json({ success: false, message: "Delete failed or record not found." });

      res.json({ success: true, message: "Deleted successfully" });
    } catch (err) {
      res.json({ success: false, message: err.message });
    }
  },
};

module.exports = portfolioSectionController;
