const { service_tab_main_headingModel, service_tab_main_heading  } = require("../../models/home/service_tab_main_headingModel");

const service_tab_main_headingController = {
  create: async (req, res) => {
  try {
    const { heading } = req.body;

    const data = { heading: heading?.trim() }; // ✅ fixed key
    const result = await service_tab_main_heading.create(data);

    if (result?.error) {
      return res.status(400).json({ success: false, message: result.error });
    }

    res.status(201).json({
      success: true,
      message: "Services section created successfully!",
      data: result,
    });
  } catch (err) {
    res.status(500).json({ success: false, message: err.message });
  }
},

  getAll: async (req, res) => {
    try {
      const result = await service_tab_main_heading.getAll();
      if (!result.length) {
        return res.status(404).json({ success: false, message: "No section heading found." });
      }
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getSingle: async (req, res) => {
    try {
      const entry = await service_tab_main_heading.getsingle(req.params.id);
      if (!entry) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }
      res.status(200).json({ success: true, data: entry });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  update: async (req, res) => {
    try {
      const { heading } = req.body;
      const data = { heading: heading?.trim() };

      const updated = await service_tab_main_heading.update(req.params.id, data);
      if (!updated) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }

      res.status(200).json({ success: true, message: "Heading updated!", data: updated });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  delete: async (req, res) => {
    try {
      const deleted = await service_tab_main_heading.delete(req.params.id);
      if (!deleted) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }
      res.status(200).json({ success: true, ...deleted });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },
};

module.exports = service_tab_main_headingController;
