const { servicesSection } = require("../../models/home/servicesSectionModel");

const ServicesSectionController = {
  create: async (req, res) => {
    try {
      const { main_heading } = req.body;

      const data = { main_heading: main_heading?.trim() };
      const result = await servicesSection.create(data);

      if (result?.error) {
        return res.status(400).json({ success: false, message: result.error });
      }

      res.status(201).json({
        success: true,
        message: "Services section created successfully!",
        data: result,
      });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getAll: async (req, res) => {
    try {
      const result = await servicesSection.getAll();
      if (!result.length) {
        return res.status(404).json({ success: false, message: "No section heading found." });
      }
      res.status(200).json({ success: true, data: result });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  getSingle: async (req, res) => {
    try {
      const entry = await servicesSection.getSingle(req.params.id);
      if (!entry) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }
      res.status(200).json({ success: true, data: entry });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  update: async (req, res) => {
    try {
      const { main_heading } = req.body;
      const data = { main_heading: main_heading?.trim() };

      const updated = await servicesSection.update(req.params.id, data);
      if (!updated) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }

      res.status(200).json({ success: true, message: "Heading updated!", data: updated });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },

  delete: async (req, res) => {
    try {
      const deleted = await servicesSection.delete(req.params.id);
      if (!deleted) {
        return res.status(404).json({ success: false, message: "Heading not found." });
      }
      res.status(200).json({ success: true, ...deleted });
    } catch (err) {
      res.status(500).json({ success: false, message: err.message });
    }
  },
};

module.exports = ServicesSectionController;
