const { DataTypes } = require("sequelize");
const sequelize = require("../../config/sequelize");

const faqModel = sequelize.define(
  "faqs",
  {
    question: { type: DataTypes.STRING, allowNull: false },
    answer: { type: DataTypes.STRING, allowNull: false },
    pages: {type: DataTypes.JSON, allowNull: false, defaultValue: []},
    show_on_home: {type: DataTypes.BOOLEAN,defaultValue: false,allowNull: false},
  },
  {
    tableName: "faqs",
    underscored: true,
  }
);

const faqSection = {
  create: async (data) => {
    try {
      if (!data.question || !data.answer) return { error: "No Faqs Found." };
      return await faqModel.create(data);
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await faqModel.findAll({ order: [["created_at", "DESC"]] });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await faqModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await faqModel.findByPk(id);
      if (!record) return null;
      await faqModel.update(data, { where: { id } });
      return await faqModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await faqModel.destroy({ where: { id } });
      if (!deleted) return null;
      return { message: "Services section deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};
module.exports = { faqModel , faqSection };
