const { DataTypes } = require("sequelize");
const sequelize = require("../../config/sequelize");

const reviews_headingModel = sequelize.define("service_tab_main_heading", {
  heading: { type: DataTypes.STRING, allowNull: false },
 
}, {
  tableName: "reviews_heading",
  underscored: true,
});

const reviews_heading = {
  create: async (data) => {
    if (!data.heading) {
      return { error: "Heading is required." };
    }
    return await reviews_headingModel.create(data);
  },

    getAll: async () => {
      try {
        return await reviews_headingModel.findAll({ order: [["created_at", "DESC"]] });
      } catch (err) {
        throw err;
      }
    },



  getsingle: async (id) => {
    try {
      return await reviews_headingModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update : async (id, data) => {
    try {
      const record = await reviews_headingModel.findByPk(id);
      if (!record) return null;
      await reviews_headingModel.update(data, { where: { id } });
      return await reviews_headingModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },
  delete : async (id) => {
    try {
      const deleted = await reviews_headingModel.destroy({ where: { id } });
      if (!deleted) return null;
      return { message: "Service tab main heading deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },

};

module.exports = { reviews_headingModel, reviews_heading };
