const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const WebDevelopmentServiceTemplateModel = sequelize.define(
  "webdevelopment_service_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    services_tabs_section_image: { type: DataTypes.STRING, allowNull: true },
    service_section_Tabs: { type: DataTypes.JSON, allowNull: true },
    all_services_grid: { type: DataTypes.JSON, allowNull: true },
    why_choose_us_section: { type: DataTypes.JSON, allowNull: true },
    info_cards_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }

  },
  {
    tableName: "webdevelopment_service_template",
    underscored: true,
    timestamps: true,
  }
);

const WebDevelopmentServiceTemplate = {
  create: async (data) => {
    try {
      const newRecord = await WebDevelopmentServiceTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await WebDevelopmentServiceTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await WebDevelopmentServiceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await WebDevelopmentServiceTemplateModel.findByPk(id);
      if (!record) return null;

      await WebDevelopmentServiceTemplateModel.update(data, { where: { id } });
      return await WebDevelopmentServiceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await WebDevelopmentServiceTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { WebDevelopmentServiceTemplate, WebDevelopmentServiceTemplateModel };
