const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const brandingAgencyTemplateModel = sequelize.define(
  "branding_agency_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    services_tabs_section_image: { type: DataTypes.STRING, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    why_us_image: { type: DataTypes.STRING, allowNull: true },
    why_choose_us_section: { type: DataTypes.JSON, allowNull: true },
    all_services_grid: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "branding_agency_template",
    underscored: true,
    timestamps: true,
  }
);

const brandingAgencyTemplate = {
  create: async (data) => {
    try {
      const newRecord = await brandingAgencyTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await brandingAgencyTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await brandingAgencyTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await brandingAgencyTemplateModel.findByPk(id);
      if (!record) return null;

      await brandingAgencyTemplateModel.update(data, { where: { id } });
      return await brandingAgencyTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await brandingAgencyTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { brandingAgencyTemplate, brandingAgencyTemplateModel };
