const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const contentmarketingTemplateModel = sequelize.define(
  "content_marketing_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_achievements_section: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    our_experties: { type: DataTypes.JSON, allowNull: true },
    technologies_we_work_section: { type: DataTypes.JSON, allowNull: true },
    about_us: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "content_marketing_template",
    underscored: true,
    timestamps: true,
  }
);

const contentmarketingTemplate = {
  create: async (data) => {
    try {
      const newRecord = await contentmarketingTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await contentmarketingTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await contentmarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await contentmarketingTemplateModel.findByPk(id);
      if (!record) return null;

      await contentmarketingTemplateModel.update(data, { where: { id } });
      return await contentmarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await contentmarketingTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { contentmarketingTemplate, contentmarketingTemplateModel };
