const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const digitalmarketingServiceTemplateModel = sequelize.define(
  "digital_marketing_service_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    service_section_Tabs: { type: DataTypes.JSON, allowNull: true },
    services_cards: { type: DataTypes.JSON, allowNull: true },
    all_services_grid: { type: DataTypes.JSON, allowNull: true },
    technologies_we_work_with: { type: DataTypes.JSON, allowNull: true },
    info_cards_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }

  },
  {
    tableName: "digital_marketing_service_template",
    underscored: true,
    timestamps: true,
  }
);

const digitalmarketingServiceTemplate = {
  create: async (data) => {
    try {
      const newRecord = await digitalmarketingServiceTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await digitalmarketingServiceTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await digitalmarketingServiceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await digitalmarketingServiceTemplateModel.findByPk(id);
      if (!record) return null;

      await digitalmarketingServiceTemplateModel.update(data, { where: { id } });
      return await digitalmarketingServiceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await digitalmarketingServiceTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { digitalmarketingServiceTemplate, digitalmarketingServiceTemplateModel };
