const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const ecommercemarketingTemplateModel = sequelize.define(
  "ecommerce_marketing_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_achievements_section: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    technnologies_section: { type: DataTypes.JSON, allowNull: true },
    about_us: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "ecommerce_marketing_template",
    underscored: true,
    timestamps: true,
  }
);

const ecommercemarketingTemplate = {
  create: async (data) => {
    try {
      const newRecord = await ecommercemarketingTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await ecommercemarketingTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await ecommercemarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await ecommercemarketingTemplateModel.findByPk(id);
      if (!record) return null;

      await ecommercemarketingTemplateModel.update(data, { where: { id } });
      return await ecommercemarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await ecommercemarketingTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { ecommercemarketingTemplate, ecommercemarketingTemplateModel };
