const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const internetMarketingTemplateModel = sequelize.define(
  "internet_marketing_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    services_tabs_section_image: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    information_card: { type: DataTypes.JSON, allowNull: true },
    technnology_used: { type: DataTypes.JSON, allowNull: true },
    our_experties_section: { type: DataTypes.JSON, allowNull: true },
    about_us_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "internet_marketing_template",
    underscored: true,
    timestamps: true,
  }
);

const internetMarketingTemplate = {
  create: async (data) => {
    try {
      const newRecord = await internetMarketingTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await internetMarketingTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await internetMarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await internetMarketingTemplateModel.findByPk(id);
      if (!record) return null;

      await internetMarketingTemplateModel.update(data, { where: { id } });
      return await internetMarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await internetMarketingTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { internetMarketingTemplate, internetMarketingTemplateModel };
