const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const listingserviceTemplateModel = sequelize.define(
  "listing_service_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_achievements_section: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    technologies_we_work_section: { type: DataTypes.JSON, allowNull: true },
    certification_sections: { type: DataTypes.JSON, allowNull: true },
    our_top_clients_section: { type: DataTypes.JSON, allowNull: true },
    portfolio_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "listing_service_template",
    underscored: true,
    timestamps: true,
  }
);

const listingserviceTemplate = {
  create: async (data) => {
    try {
      const newRecord = await listingserviceTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await listingserviceTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await listingserviceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await listingserviceTemplateModel.findByPk(id);
      if (!record) return null;

      await listingserviceTemplateModel.update(data, { where: { id } });
      return await listingserviceTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await listingserviceTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { listingserviceTemplate, listingserviceTemplateModel };
