const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const searchenginemarketingTemplateModel = sequelize.define(
  "search_engine_marketing_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_achievements_section: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    technnologies_section: { type: DataTypes.JSON, allowNull: true },
    our_experties: { type: DataTypes.JSON, allowNull: true },
    about_us: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "search_engine_marketing_template",
    underscored: true,
    timestamps: true,
  }
);

const searchenginemarketingTemplate = {
  create: async (data) => {
    try {
      const newRecord = await searchenginemarketingTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await searchenginemarketingTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await searchenginemarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await searchenginemarketingTemplateModel.findByPk(id);
      if (!record) return null;

      await searchenginemarketingTemplateModel.update(data, { where: { id } });
      return await searchenginemarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await searchenginemarketingTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { searchenginemarketingTemplate, searchenginemarketingTemplateModel };
