const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const socialmediamarketingTemplateModel = sequelize.define(
  "social_media_marketing_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    stand_out_section: { type: DataTypes.JSON, allowNull: true },
    our_achievements_section: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    our_experties: { type: DataTypes.JSON, allowNull: true },
    technologies_we_work_section: { type: DataTypes.JSON, allowNull: true },
    our_profile: { type: DataTypes.JSON, allowNull: true },
    about_us: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "social_media_marketing_template",
    underscored: true,
    timestamps: true,
  }
);

const socialmediamarketingTemplate = {
  create: async (data) => {
    try {
      const newRecord = await socialmediamarketingTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await socialmediamarketingTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await socialmediamarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await socialmediamarketingTemplateModel.findByPk(id);
      if (!record) return null;

      await socialmediamarketingTemplateModel.update(data, { where: { id } });
      return await socialmediamarketingTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await socialmediamarketingTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { socialmediamarketingTemplate, socialmediamarketingTemplateModel };
