const { DataTypes, Op } = require("sequelize");
const sequelize = require("../../config/sequelize");

const softwaredevelopmentTemplateModel = sequelize.define(
  "software_development_template",
  {
    page_heading: { type: DataTypes.STRING, allowNull: true },
    banner: { type: DataTypes.JSON, allowNull: true },
    services_tabs_section_image: { type: DataTypes.STRING, allowNull: true },
    services_tabs_section_text: { type: DataTypes.JSON, allowNull: true },
    our_services_section: { type: DataTypes.JSON, allowNull: true },
    services_tab_section: { type: DataTypes.JSON, allowNull: true },
    all_services_grid: { type: DataTypes.JSON, allowNull: true },
    info_cards_section: { type: DataTypes.JSON, allowNull: true },
    enable_faq: { type: DataTypes.BOOLEAN, allowNull: true },
    enable_review: { type: DataTypes.BOOLEAN, allowNull: true }
  },
  {
    tableName: "software_development_template",
    underscored: true,
    timestamps: true,
  }
);

const softwaredevelopmentTemplate = {
  create: async (data) => {
    try {
      const newRecord = await softwaredevelopmentTemplateModel.create(data);
      return newRecord;
    } catch (err) {
      throw err;
    }
  },

  getAll: async () => {
    try {
      return await softwaredevelopmentTemplateModel.findAll({
        order: [["created_at", "DESC"]],
      });
    } catch (err) {
      throw err;
    }
  },

  getSingle: async (id) => {
    try {
      return await softwaredevelopmentTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  update: async (id, data) => {
    try {
      const record = await softwaredevelopmentTemplateModel.findByPk(id);
      if (!record) return null;

      await softwaredevelopmentTemplateModel.update(data, { where: { id } });
      return await softwaredevelopmentTemplateModel.findByPk(id);
    } catch (err) {
      throw err;
    }
  },

  delete: async (id) => {
    try {
      const deleted = await softwaredevelopmentTemplateModel.destroy({
        where: { id },
      });
      if (!deleted) return null;
      return { message: "Template deleted successfully!" };
    } catch (err) {
      throw err;
    }
  },
};


module.exports = { softwaredevelopmentTemplate, softwaredevelopmentTemplateModel };
