const express = require("express");
const router = express.Router();
const multer = require("multer");
const path = require("path");
const fs = require("fs");

const middlewares = require("../middlewares");
const authControllers = require("../controller/authControllers");
const BlogPostControllers = require("../controller/blogs/Blogpostcontrollers");
const PageBlogControllers = require("../controller/blogs/pageBlogController");
const CategoryControllers = require("../controller/blogs/CategoryControllers");
const MetaDataController = require("../controller/metaDataController");
const SliderBannerController = require("../controller/home/sliderBannerController");
const ServicesSectionController = require("../controller/home/servicesSectionController");
const ServicesController = require("../controller/services/servicesController");
const WhoWeAreController = require("../controller/home/whoWeAreController");
const Section4VideoController = require("../controller/home/section4VideoController");
const AgencyControllers = require("../controller/home/agencyControllers");
const IconBoxController = require("../controller/home/IconBoxController");
const logosliderController = require("../controller/home/logosliderController");
const ServicesTabController = require("../controller/home/servicesTabController");
const Section5VideoController = require("../controller/home/section5VideoController");
const portfolioItemModel = require("../models/home/portfolioItemModel");
const PortfolioItemController = require("../controller/home/portfolioItemController");
const portfolioSectionController = require("../controller/home/portfolioSectionController");
const faqController = require("../controller/home/faqController");
const ReviewController = require("../controller/home/reviewController");
const servicetab_main_headingController = require("../controller/home/servicetab_main_headingController");
const { service_tab_main_heading } = require("../models/home/service_tab_main_headingModel");
const service_tab_main_headingController = require("../controller/home/service_tab_main_headingController");
const reviews_headingController = require("../controller/home/reviews_headingController");
const { getAllDataHomePage } = require("../controller/front-end-apis/homepageController");
const homepageController = require("../controller/front-end-apis/homepageController");
const ServicesDetailMediaController = require("../controller/media_upload/ServicesDetailMediaController");
const WebDevServiceTemplateController = require("../controller/services_templates/webDevServiceTemplateController");
const brandingAgencyTemplateController = require("../controller/services_templates/brandingAgencyTemplateController");
const { graphicdesigningTemplate } = require("../models/services_templates/graphicdesigningTemplateModel");
const graphicDesigningTemplateController = require("../controller/services_templates/graphicdesigningTemplateController");
const softwaredevelopmentTemplateController = require("../controller/services_templates/softwaredevelopmentTemplateController");
const WebDesignServiceTemplateController = require("../controller/services_templates/WebDesignServiceTemplateController");
const applicationdevelopmentTemplateController = require("../controller/services_templates/applicationdevelopmentTemplateController");
const VirtualEmployeesTemplateController = require("../controller/services_templates/VirtualEmployeesTemplateController");
const reputationmanagementTemplateController = require("../controller/services_templates/reputationmanagementTemplateController");
const internetmarketingTemplateController = require("../controller/services_templates/internetmarketingTemplateController");
const listingserviceTemplateController = require("../controller/services_templates/listingserviceTemplateController");
const contentmarketingTemplateController = require("../controller/services_templates/contentmarketingTemplateController");
const emailmarketingTemplateController = require("../controller/services_templates/emailmarketingTemplateController");
const searchenginemarketingTemplateController = require("../controller/services_templates/searchenginemarketingTemplateController");
const ecommercemarketingTemplateController = require("../controller/services_templates/ecommercemarketingTemplateController");
const socialmediamarketingTemplateController = require("../controller/services_templates/socialmediamarketingTemplateController");
const seomarketingTemplateController = require("../controller/services_templates/seomarketingTemplateController");
const pagesInfoController = require("../controller/services_template_pages/pagesInfoController");
const digitalmarketingServiceTemplateController = require("../controller/services_templates/digitalmarketingServiceTemplateController");
const reviews_faq_filterController = require("../controller/services_templates/reviews_faqs_filter/reviews_faq_filterController");

const blogDir = path.join(__dirname, "../uploads/blog_images");
const pageBlogDir = path.join(__dirname, "../uploads/page_blog_images");

if (!fs.existsSync(blogDir)) fs.mkdirSync(blogDir, { recursive: true });
if (!fs.existsSync(pageBlogDir)) fs.mkdirSync(pageBlogDir, { recursive: true });

const blogImageStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/blog_images/"),
  filename: (req, file, cb) => cb(null, `blog_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadBlogImage = multer({ storage: blogImageStorage });

const pageBlogImageStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/page_blog_images/"),
  filename: (req, file, cb) => cb(null, `page_blog_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadPageBlogImage = multer({ storage: pageBlogImageStorage });




const reviewImageDirectory = path.join(__dirname, "../uploads/slider_banner_images");
if (!fs.existsSync(reviewImageDirectory)) fs.mkdirSync(reviewImageDirectory, { recursive: true });

const reviewImageDirectoryStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/review_images/"),
  filename: (req, file, cb) => cb(null, `review_images_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadreviewImageDirectory = multer({ storage: reviewImageDirectoryStorage });


const sliderBannerDir = path.join(__dirname, "../uploads/slider_banner_images");
if (!fs.existsSync(sliderBannerDir)) fs.mkdirSync(sliderBannerDir, { recursive: true });

const sliderBannerImageStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/slider_banner_images/"),
  filename: (req, file, cb) => cb(null, `slider_banner_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadSliderBannerImage = multer({ storage: sliderBannerImageStorage });


const servicesDir = path.join(__dirname, "../uploads/services_images");
if (!fs.existsSync(servicesDir)) fs.mkdirSync(servicesDir, { recursive: true });

const servicesImageStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/services_images/"),
  filename: (req, file, cb) => cb(null, `service_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadServicesImage = multer({ storage: servicesImageStorage });




const iconBoxStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/icon_boxes/"),
  filename: (req, file, cb) => cb(null, `icon_box_${Date.now()}${path.extname(file.originalname)}`)
});

const uploadIconBoxImage = multer({ storage: iconBoxStorage })



const logoSliderDir = path.join(__dirname, "../uploads/logo_slider");
if (!fs.existsSync(logoSliderDir)) fs.mkdirSync(logoSliderDir, { recursive: true });

const logoSliderStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/logo_slider/"),
  filename: (req, file, cb) =>
    cb(null, `logo_slider_${Date.now()}${path.extname(file.originalname)}`)
});

const uploadLogoSlider = multer({ storage: logoSliderStorage });


const whoWeAreDir = path.join(__dirname, "../uploads/who_we_are_images");
if (!fs.existsSync(whoWeAreDir)) fs.mkdirSync(whoWeAreDir, { recursive: true });

const whoWeAreImageStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/who_we_are_images/"),
  filename: (req, file, cb) => cb(null, `who_we_are_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadWhoWeAreImage = multer({ storage: whoWeAreImageStorage });



const reviewImageDir = path.join(__dirname, "../uploads/review_images");
if (!fs.existsSync(reviewImageDir)) fs.mkdirSync(reviewImageDir, { recursive: true });

const reviewImageStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/review_images/"),
  filename: (req, file, cb) => cb(null, `review_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadReviewImage = multer({ storage: reviewImageStorage });




const portfolioUploadDir = "uploads/home/portfolio";

const portfolioStorage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, portfolioUploadDir);
  },
  filename: (req, file, cb) => {
    const uniqueSuffix = Date.now() + "_" + Math.round(Math.random() * 1E9);
    const ext = path.extname(file.originalname);
    cb(null, `portfolio_${uniqueSuffix}${ext}`);
  },
});

const portfolioUpload = multer({ storage: portfolioStorage });


const section5Dir = path.join(__dirname, "../uploads/home/videos");
if (!fs.existsSync(section5Dir)) fs.mkdirSync(section5Dir, { recursive: true });

const section5VideoStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/home/videos/"),
  filename: (req, file, cb) => cb(null, `home_video_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadHomeVideo = multer({ storage: section5VideoStorage });


//added by me shahzaib

const servicesDetailMediaDir = path.join(__dirname, "../uploads/services_detail_media");
if (!fs.existsSync(servicesDetailMediaDir)) {
  fs.mkdirSync(servicesDetailMediaDir, { recursive: true });
}

const servicesMediaStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/services_detail_media/"),
  filename: (req, file, cb) => cb(null, `media_${Date.now()}${path.extname(file.originalname)}`)
});

const uploadServicesDetailMedia = multer({ storage: servicesMediaStorage });




const section4Dir = path.join(__dirname, "../uploads/section_4_videos");
if (!fs.existsSync(section4Dir)) fs.mkdirSync(section4Dir, { recursive: true });

const videoStorage = multer.diskStorage({
  destination: (req, file, cb) => cb(null, "uploads/section_4_videos/"),
  filename: (req, file, cb) => cb(null, `section4_${Date.now()}${path.extname(file.originalname)}`)
});
const uploadSection4Video = multer({ storage: videoStorage });

router.get("/testing", (req, res) => {
  console.log("API Hit");
  res.send("API Hit !!");
});

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, "uploads/icon_boxes");
  },
  filename: function (req, file, cb) {
    cb(null, Date.now() + "_" + file.originalname);
  }
});
const upload = multer({ storage });

// ====================== AUTHENTICATION ===========================
router.post("/signup", authControllers.signup);
router.post("/login", authControllers.login);

// =============== USER CRUD ==============
router.get('/users', middlewares.authMiddleware, authControllers.getAllUsers);
router.delete('/user/:id', middlewares.authMiddleware, authControllers.deleteUser);
router.patch('/user/:id', middlewares.authMiddleware, authControllers.updateUser);
router.get('/user/:id', middlewares.authMiddleware, authControllers.getSingleUser);

// ============== Meta Section ================
router.post("/meta", middlewares.authMiddleware, MetaDataController.create);
router.get("/meta", middlewares.authMiddleware, MetaDataController.getAll);
router.get("/meta/:id", middlewares.authMiddleware, MetaDataController.getSingle);
router.patch("/meta/:id", middlewares.authMiddleware, MetaDataController.update);
router.delete("/meta/:id", middlewares.authMiddleware, MetaDataController.delete);
// =============== Meta Section by slug ================
router.get("/meta/page_for/:page_for", middlewares.authMiddleware, MetaDataController.get_Single_page_by_slug);
// =============== Category CRUD ==============
router.post('/category', middlewares.authMiddleware, CategoryControllers.create);
router.get('/category', middlewares.authMiddleware, CategoryControllers.getAllCategory);
router.patch('/category/:id', middlewares.authMiddleware, CategoryControllers.updateCategory);
router.delete('/category/:id', middlewares.authMiddleware, CategoryControllers.deleteCategory);
router.get('/category/:id', middlewares.authMiddleware, CategoryControllers.getSingleCategory);

// =============== Blog Posts CRUD ==============
router.post("/posts", middlewares.authMiddleware, uploadBlogImage.single("feature_image"), BlogPostControllers.createPost);
router.get("/posts", middlewares.authMiddleware, BlogPostControllers.getAllPosts);
router.get("/posts/:id", middlewares.authMiddleware, BlogPostControllers.getSinglePost);
router.patch("/posts/:id", middlewares.authMiddleware, uploadBlogImage.single("feature_image"), BlogPostControllers.updatePost);
router.delete("/posts/:id", middlewares.authMiddleware, BlogPostControllers.deletePost);
router.get("/posts/slug/:slug", middlewares.authMiddleware, BlogPostControllers.getSinglePostBySlug);

// =============== Page Blog Content ==============
router.post("/page-blog", middlewares.authMiddleware, uploadPageBlogImage.single("blog_image"), PageBlogControllers.createEntry);
router.get("/page-blog", middlewares.authMiddleware, PageBlogControllers.getAllEntries);
router.get("/page-blog/:id", middlewares.authMiddleware, PageBlogControllers.getSingleEntry);
router.patch("/page-blog/:id", middlewares.authMiddleware, uploadPageBlogImage.single("blog_image"), PageBlogControllers.updateEntry);
router.delete("/page-blog/:id", middlewares.authMiddleware, PageBlogControllers.deleteEntry);



// =============== home page slider banner ==============

router.post("/home/slider-banner", middlewares.authMiddleware, uploadSliderBannerImage.single("banner_img"), SliderBannerController.create);
router.get("/home/slider-banner", middlewares.authMiddleware, SliderBannerController.getAll);
router.get("/home/slider-banner/:id", middlewares.authMiddleware, SliderBannerController.getSingle);
router.patch("/home/slider-banner/:id", middlewares.authMiddleware, uploadSliderBannerImage.single("banner_img"), SliderBannerController.update);
router.delete("/home/slider-banner/:id", middlewares.authMiddleware, SliderBannerController.delete);



// ====================== Home Page Services Section ===========================
router.post("/home/services-section", middlewares.authMiddleware, ServicesSectionController.create);
router.get("/home/services-section", middlewares.authMiddleware, ServicesSectionController.getAll);
router.get("/home/services-section/:id", middlewares.authMiddleware, ServicesSectionController.getSingle);
router.patch("/home/services-section/:id", middlewares.authMiddleware, ServicesSectionController.update);
router.delete("/home/services-section/:id", middlewares.authMiddleware, ServicesSectionController.delete);

// ======================  Services Section ===========================
router.post("/services", middlewares.authMiddleware, uploadServicesImage.single("service_img"), ServicesController.create);
router.get("/services", middlewares.authMiddleware, ServicesController.getAll);
router.get("/services/:id", middlewares.authMiddleware, ServicesController.getSingle);
router.patch("/services/:id", middlewares.authMiddleware, uploadServicesImage.single("service_img"), ServicesController.update);
router.delete("/services/:id", middlewares.authMiddleware, ServicesController.delete);


// ======================Home Page Who We Are Section ===========================

router.post("/home/who-we-are", middlewares.authMiddleware, uploadWhoWeAreImage.single("main_heading_img"), WhoWeAreController.create);
router.get("/home/who-we-are", middlewares.authMiddleware, WhoWeAreController.getAll);
router.get("/home/who-we-are/:id", middlewares.authMiddleware, WhoWeAreController.getSingle);
router.patch("/home/who-we-are/:id", middlewares.authMiddleware, uploadWhoWeAreImage.single("main_heading_img"), WhoWeAreController.update);
router.delete("/home/who-we-are/:id", middlewares.authMiddleware, WhoWeAreController.delete);


// ====================== Home Page Section 4 Video ===========================
router.post("/home/section-4-video", middlewares.authMiddleware, uploadSection4Video.single("video_url"), Section4VideoController.create);
router.get("/home/section-4-video", middlewares.authMiddleware, Section4VideoController.getAll);
router.get("/home/section-4-video/:id", middlewares.authMiddleware, Section4VideoController.getSingle);
router.patch("/home/section-4-video/:id", middlewares.authMiddleware, uploadSection4Video.single("video_url"), Section4VideoController.update);
router.delete("/home/section-4-video/:id", middlewares.authMiddleware, Section4VideoController.delete);


// Routes
router.post("/home/agency-section" , middlewares.authMiddleware, AgencyControllers.create);
router.get("/home/agency-section", middlewares.authMiddleware, AgencyControllers.getAll);
router.get("/home/agency-section/:id", middlewares.authMiddleware, AgencyControllers.getSingle);
router.patch("/home/agency-section/:id", middlewares.authMiddleware, AgencyControllers.update);
router.delete("/home/agency-section/:id", middlewares.authMiddleware, AgencyControllers.delete);


// ====================== Icon Boxes ===========================

router.post("/home/icon-box", middlewares.authMiddleware, uploadIconBoxImage.single("image_path"), IconBoxController.create);
router.get("/home/icon-box", middlewares.authMiddleware, IconBoxController.getAll);
router.get("/home/icon-box/:id", middlewares.authMiddleware, IconBoxController.getSingle);
router.patch("/home/icon-box/:id", middlewares.authMiddleware, uploadIconBoxImage.single("image_path"), IconBoxController.update);
router.delete("/home/icon-box/:id", middlewares.authMiddleware, IconBoxController.delete);


// ====================== Logo Slider ===========================

router.post("/logoslider", uploadLogoSlider.single("image"), logosliderController.create);
router.get("/logoslider", logosliderController.getAll);
router.get("/logoslider/:id", logosliderController.getSingle);
router.patch("/logoslider/:id", uploadLogoSlider.single("image"), logosliderController.update);
router.delete("/logoslider/:id", logosliderController.delete);
router.get("/logoslider/filter/:logo_for", logosliderController.filterlogoforwise);



// ====================== Services Tabs ===========================
router.post("/services-tab", middlewares.authMiddleware, ServicesTabController.create);
router.get("/services-tab", middlewares.authMiddleware, ServicesTabController.getAll);
router.get("/services-tab/:id", middlewares.authMiddleware, ServicesTabController.getSingle);
router.patch("/services-tab/:id", middlewares.authMiddleware, ServicesTabController.update);
router.delete("/services-tab/:id", middlewares.authMiddleware, ServicesTabController.delete);



router.post("/home/video", middlewares.authMiddleware, uploadHomeVideo.single("video"), Section5VideoController.create);
router.get("/home/video", middlewares.authMiddleware, Section5VideoController.getAll);
router.get("/home/video/:id", middlewares.authMiddleware, Section5VideoController.getSingle);
router.patch("/home/video/:id", middlewares.authMiddleware, uploadHomeVideo.single("video"), Section5VideoController.update);
router.delete("/home/video/:id", middlewares.authMiddleware, Section5VideoController.delete);


// ====================== Portfolio Items ===========================

router.post("/portfolio-item", portfolioUpload.single("media"), PortfolioItemController.create);
router.get("/portfolio-item", PortfolioItemController.getAll);
router.get("/portfolio-item/:id", PortfolioItemController.getById);
router.put("/portfolio-item/:id", portfolioUpload.single("media"), PortfolioItemController.update);
router.delete("/portfolio-item/:id", PortfolioItemController.delete);






// ====================== Portfolio Section ===========================

// // Routes

// Routes
router.post("/home/faqs" , middlewares.authMiddleware, faqController.create);
router.get("/home/faqs", middlewares.authMiddleware, faqController.getAll);
router.get("/home/faqs/:id", middlewares.authMiddleware, faqController.getSingle);
router.patch("/home/faqs/:id", middlewares.authMiddleware, faqController.update);
router.delete("/home/faqs/:id", middlewares.authMiddleware, faqController.delete);


// reviews 
// ====================== Reviews ===========================
router.post("/home/reviews",middlewares.authMiddleware,uploadReviewImage.single("reviewer_thumbnail"),ReviewController.create);
router.get("/home/reviews", middlewares.authMiddleware, ReviewController.getAll);
router.get("/home/reviews/:id", middlewares.authMiddleware, ReviewController.getSingle);
router.patch("/home/reviews/:id",middlewares.authMiddleware,uploadReviewImage.single("reviewer_thumbnail"),ReviewController.update);
router.delete("/home/reviews/:id", middlewares.authMiddleware, ReviewController.delete);

//service tag heading
router.get("/home/service-tag-main-heading", middlewares.authMiddleware, servicetab_main_headingController.getAll);
router.get("/home/service-tag-main-heading/:id", middlewares.authMiddleware, servicetab_main_headingController.getSingle);
router.post("/home/service-tag-main-heading", middlewares.authMiddleware, servicetab_main_headingController.create);
router.patch("/home/service-tag-main-heading/:id", middlewares.authMiddleware, servicetab_main_headingController.update);
router.delete("/home/service-tag-main-heading/:id", middlewares.authMiddleware, servicetab_main_headingController.delete);  


//service tab heading
router.get("/home/service-tab-main-heading", middlewares.authMiddleware, service_tab_main_headingController.getAll);
router.get("/home/service-tab-main-heading/:id", middlewares.authMiddleware, service_tab_main_headingController.getSingle);
router.post("/home/service-tab-main-heading", middlewares.authMiddleware, service_tab_main_headingController.create);
router.patch("/home/service-tab-main-heading/:id", middlewares.authMiddleware, service_tab_main_headingController.update);
router.delete("/home/service-tab-main-heading/:id", middlewares.authMiddleware, service_tab_main_headingController.delete);  


//portfolio section tab heading
router.get("/home/portfolio-main-heading", middlewares.authMiddleware, portfolioSectionController.getAll);
router.get("/home/portfolio-main-heading/:id", middlewares.authMiddleware, portfolioSectionController.getSingle);
router.post("/home/portfolio-main-heading", middlewares.authMiddleware, portfolioSectionController.create);
router.patch("/home/portfolio-main-heading/:id", middlewares.authMiddleware, portfolioSectionController.update);
router.delete("/home/portfolio-main-heading/:id", middlewares.authMiddleware, portfolioSectionController.delete);  


// ====================== Reviews Heading ===========================
router.get("/home/reviews-heading", middlewares.authMiddleware, reviews_headingController.getAll);
router.get("/home/reviews-heading/:id", middlewares.authMiddleware, reviews_headingController.getSingle);
router.post("/home/reviews-heading", middlewares.authMiddleware, reviews_headingController.create);
router.patch("/home/reviews-heading/:id", middlewares.authMiddleware, reviews_headingController.update);
router.delete("/home/reviews-heading/:id", middlewares.authMiddleware, reviews_headingController.delete);  


// ====================== Home Page Main Data ===========================
router.get("/home-page-all-data", middlewares.authMiddleware, homepageController.getAllDataHomePage);



// ====================== Services Detail Media ===========================

router.post("/services-detail-media",  middlewares.authMiddleware,uploadServicesDetailMedia.single("file"), ServicesDetailMediaController.create);
router.get("/services-detail-media",  middlewares.authMiddleware,ServicesDetailMediaController.getAll);
router.get("/services-detail-media/:id",  middlewares.authMiddleware,ServicesDetailMediaController.getSingle);
router.patch("/services-detail-media/:id", middlewares.authMiddleware, uploadServicesDetailMedia.single("file"), ServicesDetailMediaController.update);
router.delete("/services-detail-media/:id",  middlewares.authMiddleware,ServicesDetailMediaController.delete);



// ====================== Web Development Service Template ===========================

// POST new template
router.post("/web-development-service-template", middlewares.authMiddleware, WebDevServiceTemplateController.createTemplate);
router.get("/web-development-service-template", middlewares.authMiddleware, WebDevServiceTemplateController.getAllTemplates);
router.get("/web-development-service-template/:id", middlewares.authMiddleware, WebDevServiceTemplateController.getTemplateById);
router.patch("/web-development-service-template/:id", middlewares.authMiddleware, WebDevServiceTemplateController.updateTemplate);
router.delete("/web-development-service-template/:id", middlewares.authMiddleware, WebDevServiceTemplateController.deleteTemplate);

// Brand Agency template
router.post("/brand-agency-template", middlewares.authMiddleware, brandingAgencyTemplateController.createTemplate);
router.get("/brand-agency-template", middlewares.authMiddleware, brandingAgencyTemplateController.getAllTemplates);
router.get("/brand-agency-template/:id", middlewares.authMiddleware, brandingAgencyTemplateController.getTemplateById);
router.patch("/brand-agency-template/:id", middlewares.authMiddleware, brandingAgencyTemplateController.updateTemplate);
router.delete("/brand-agency-template/:id", middlewares.authMiddleware, brandingAgencyTemplateController.deleteTemplate);


// Graphic Design Service template
router.post("/graphic-design-service-template", middlewares.authMiddleware, graphicDesigningTemplateController.createTemplate);
router.get("/graphic-design-service-template", middlewares.authMiddleware, graphicDesigningTemplateController.getAllTemplates);
router.get("/graphic-design-service-template/:id", middlewares.authMiddleware, graphicDesigningTemplateController.getTemplateById);
router.patch("/graphic-design-service-template/:id", middlewares.authMiddleware, graphicDesigningTemplateController.updateTemplate);
router.delete("/graphic-design-service-template/:id", middlewares.authMiddleware, graphicDesigningTemplateController.deleteTemplate);


// Software Development Service template
router.post("/software-development-service-template", middlewares.authMiddleware, softwaredevelopmentTemplateController.createTemplate);
router.get("/software-development-service-template", middlewares.authMiddleware, softwaredevelopmentTemplateController.getAllTemplates);
router.get("/software-development-service-template/:id", middlewares.authMiddleware, softwaredevelopmentTemplateController.getTemplateById);
router.patch("/software-development-service-template/:id", middlewares.authMiddleware, softwaredevelopmentTemplateController.updateTemplate);
router.delete("/software-development-service-template/:id", middlewares.authMiddleware, softwaredevelopmentTemplateController.deleteTemplate);


// Website Design Service template
router.post("/website-design-service-template", middlewares.authMiddleware, WebDesignServiceTemplateController.createTemplate);
router.get("/website-design-service-template", middlewares.authMiddleware, WebDesignServiceTemplateController.getAllTemplates);
router.get("/website-design-service-template/:id", middlewares.authMiddleware, WebDesignServiceTemplateController.getTemplateById);
router.patch("/website-design-service-template/:id", middlewares.authMiddleware, WebDesignServiceTemplateController.updateTemplate);
router.delete("/website-design-service-template/:id", middlewares.authMiddleware, WebDesignServiceTemplateController.deleteTemplate);


// Application Development Service template
router.post("/application-development-service-template", middlewares.authMiddleware, applicationdevelopmentTemplateController.createTemplate);
router.get("/application-development-service-template", middlewares.authMiddleware, applicationdevelopmentTemplateController.getAllTemplates);
router.get("/application-development-service-template/:id", middlewares.authMiddleware, applicationdevelopmentTemplateController.getTemplateById);
router.patch("/application-development-service-template/:id", middlewares.authMiddleware, applicationdevelopmentTemplateController.updateTemplate);
router.delete("/application-development-service-template/:id", middlewares.authMiddleware, applicationdevelopmentTemplateController.deleteTemplate);

// Virtual Employees Service template
router.post("/virtual-employees-service-template", middlewares.authMiddleware, VirtualEmployeesTemplateController.createTemplate);
router.get("/virtual-employees-service-template", middlewares.authMiddleware, VirtualEmployeesTemplateController.getAllTemplates);
router.get("/virtual-employees-service-template/:id", middlewares.authMiddleware, VirtualEmployeesTemplateController.getTemplateById);
router.patch("/virtual-employees-service-template/:id", middlewares.authMiddleware, VirtualEmployeesTemplateController.updateTemplate);
router.delete("/virtual-employees-service-template/:id", middlewares.authMiddleware, VirtualEmployeesTemplateController.deleteTemplate);


// reputation Management Service template
router.post("/reputation-management-service-template", middlewares.authMiddleware, reputationmanagementTemplateController.createTemplate);
router.get("/reputation-management-service-template", middlewares.authMiddleware, reputationmanagementTemplateController.getAllTemplates);
router.get("/reputation-management-service-template/:id", middlewares.authMiddleware, reputationmanagementTemplateController.getTemplateById);
router.patch("/reputation-management-service-template/:id", middlewares.authMiddleware, reputationmanagementTemplateController.updateTemplate);
router.delete("/reputation-management-service-template/:id", middlewares.authMiddleware, reputationmanagementTemplateController.deleteTemplate);



// internet Marketing Service template
router.post("/internet-marketing-service-template", middlewares.authMiddleware, internetmarketingTemplateController.createTemplate);
router.get("/internet-marketing-service-template", middlewares.authMiddleware, internetmarketingTemplateController.getAllTemplates);
router.get("/internet-marketing-service-template/:id", middlewares.authMiddleware, internetmarketingTemplateController.getTemplateById);
router.patch("/internet-marketing-service-template/:id", middlewares.authMiddleware, internetmarketingTemplateController.updateTemplate);
router.delete("/internet-marketing-service-template/:id", middlewares.authMiddleware, internetmarketingTemplateController.deleteTemplate);

// listing service Service template
router.post("/listing-service-template", middlewares.authMiddleware, listingserviceTemplateController.createTemplate);
router.get("/listing-service-template", middlewares.authMiddleware, listingserviceTemplateController.getAllTemplates);
router.get("/listing-service-template/:id", middlewares.authMiddleware, listingserviceTemplateController.getTemplateById);
router.patch("/listing-service-template/:id", middlewares.authMiddleware, listingserviceTemplateController.updateTemplate);
router.delete("/listing-service-template/:id", middlewares.authMiddleware, listingserviceTemplateController.deleteTemplate);


// content marketing Service template
router.post("/content-marketing-service-template", middlewares.authMiddleware, contentmarketingTemplateController.createTemplate);
router.get("/content-marketing-service-template", middlewares.authMiddleware, contentmarketingTemplateController.getAllTemplates);
router.get("/content-marketing-service-template/:id", middlewares.authMiddleware, contentmarketingTemplateController.getTemplateById);
router.patch("/content-marketing-service-template/:id", middlewares.authMiddleware, contentmarketingTemplateController.updateTemplate);
router.delete("/content-marketing-service-template/:id", middlewares.authMiddleware, contentmarketingTemplateController.deleteTemplate);


// email marketing Service template
router.post("/email-marketing-service-template", middlewares.authMiddleware, emailmarketingTemplateController.createTemplate);
router.get("/email-marketing-service-template", middlewares.authMiddleware, emailmarketingTemplateController.getAllTemplates);
router.get("/email-marketing-service-template/:id", middlewares.authMiddleware, emailmarketingTemplateController.getTemplateById);
router.patch("/email-marketing-service-template/:id", middlewares.authMiddleware, emailmarketingTemplateController.updateTemplate);
router.delete("/email-marketing-service-template/:id", middlewares.authMiddleware, emailmarketingTemplateController.deleteTemplate);


// search engine marketing Service template
router.post("/search-engine-marketing-service-template", middlewares.authMiddleware, searchenginemarketingTemplateController.createTemplate);
router.get("/search-engine-marketing-service-template", middlewares.authMiddleware, searchenginemarketingTemplateController.getAllTemplates);
router.get("/search-engine-marketing-service-template/:id", middlewares.authMiddleware, searchenginemarketingTemplateController.getTemplateById);
router.patch("/search-engine-marketing-service-template/:id", middlewares.authMiddleware, searchenginemarketingTemplateController.updateTemplate);
router.delete("/search-engine-marketing-service-template/:id", middlewares.authMiddleware, searchenginemarketingTemplateController.deleteTemplate);

// Ecommerce marketing Service template
router.post("/ecommerce-marketing-service-template", middlewares.authMiddleware, ecommercemarketingTemplateController.createTemplate);
router.get("/ecommerce-marketing-service-template", middlewares.authMiddleware, ecommercemarketingTemplateController.getAllTemplates);
router.get("/ecommerce-marketing-service-template/:id", middlewares.authMiddleware, ecommercemarketingTemplateController.getTemplateById);
router.patch("/ecommerce-marketing-service-template/:id", middlewares.authMiddleware, ecommercemarketingTemplateController.updateTemplate);
router.delete("/ecommerce-marketing-service-template/:id", middlewares.authMiddleware, ecommercemarketingTemplateController.deleteTemplate);

// Social Media marketing Service template
router.post("/social-media-marketing-service-template", middlewares.authMiddleware, socialmediamarketingTemplateController.createTemplate);
router.get("/social-media-marketing-service-template", middlewares.authMiddleware, socialmediamarketingTemplateController.getAllTemplates);
router.get("/social-media-marketing-service-template/:id", middlewares.authMiddleware, socialmediamarketingTemplateController.getTemplateById);
router.patch("/social-media-marketing-service-template/:id", middlewares.authMiddleware, socialmediamarketingTemplateController.updateTemplate);
router.delete("/social-media-marketing-service-template/:id", middlewares.authMiddleware, socialmediamarketingTemplateController.deleteTemplate);

// seo marketing Service template
router.post("/seo-service-template", middlewares.authMiddleware, seomarketingTemplateController.createTemplate);
router.get("/seo-service-template", middlewares.authMiddleware, seomarketingTemplateController.getAllTemplates);
router.get("/seo-service-template/:id", middlewares.authMiddleware, seomarketingTemplateController.getTemplateById);
router.patch("/seo-service-template/:id", middlewares.authMiddleware, seomarketingTemplateController.updateTemplate);
router.delete("/seo-service-template/:id", middlewares.authMiddleware, seomarketingTemplateController.deleteTemplate);


// digital Marketing Service template
router.post("/digital-marketing-service-template", middlewares.authMiddleware, digitalmarketingServiceTemplateController.createTemplate);
router.get("/digital-marketing-service-template", middlewares.authMiddleware, digitalmarketingServiceTemplateController.getAllTemplates);
router.get("/digital-marketing-service-template/:id", middlewares.authMiddleware, digitalmarketingServiceTemplateController.getTemplateById);
router.patch("/digital-marketing-service-template/:id", middlewares.authMiddleware, digitalmarketingServiceTemplateController.updateTemplate);
router.delete("/digital-marketing-service-template/:id", middlewares.authMiddleware, digitalmarketingServiceTemplateController.deleteTemplate);


//all pages template api

router.get("/pages-info", pagesInfoController.getAllPagesInfo);

router.get("/filter-reviews", reviews_faq_filterController.getReviewsForPage);
router.get("/filter-faqs", reviews_faq_filterController.getFaqForPage);
module.exports = router;
